<?php

require_once(__DIR__ . "/vendor/autoload.php");
require_once(__DIR__ . "/API.php");

$area = "browse";

if (! empty($_GET["area"])) {
    $area = trim($_GET["area"]);
}

?>

<div class="wrap toybox-wrapper">
    <h1>Block Library</h1>

    <nav class="nav-tab-wrapper">
        <a href="?page=toybox-block-library" class="nav-tab <?= (($area === "" || $area === "browse") ? "nav-tab-active" : "") ?>">Browse
            Available Blocks</a>
        <?php if (file_exists(get_theme_file_path("blocks"))) : ?>
            <a href="?page=toybox-block-library&area=export" class="nav-tab <?= (($area === "export") ? "nav-tab-active" : "") ?>">Export</a>
        <?php endif; ?>
    </nav>

    <div class="tab-content">
        <?php if ($area === "browse") : ?>
            <?php if (! empty($_POST)) : ?>
                <?php
                $api      = new API();
                $download = $api->downloadBlock($_POST["block"], $_POST["slug"]);
                ?>
                <?php if ($download === true) : ?>
                    <div class="alert alert-success">
                        Downloaded the block from the API successfully!
                    </div>
                <?php else : ?>
                    <div class="alert alert-error">
                        Failed to download the block from the API.
                    </div>
                <?php endif; ?>
            <?php else : ?>
                <?php
                $search = ! empty($_GET["q"]) ? $_GET["q"] : "";
                ?>
                <form method="get" action="admin.php">
                    <input type="hidden" name="page" value="toybox-block-library">
                    <div class="block-library-filters">
                        <input type="text" name="q" class="regular-text" value="<?= esc_attr($search) ?>" placeholder="Search..">
                        <?= get_submit_button(text: "Search", wrap: false) ?>
                    </div>
                </form>

                <div class="toybox-blocks-grid">
                    <?php
                    $api    = new API();
                    $page   = ! empty($_GET["bl-page"]) ? (int) $_GET["bl-page"] : 1;
                    $blocks = $api->getBlocks($page);

                    ?>
                    <?php foreach ($blocks->data as $block) : ?>
                        <div class="toybox-block">
                            <div class="toybox-block-preview">
                                <?php
                                // $blockSlug = explode("/", $blockJson->name)[1];
                                ?>
                                <img src="<?= $block->latest_version->preview_image ?>" alt="<?= $block->name ?> Preview">
                            </div>

                            <div class="toybox-block-meta">
                                <div class="title">
                                    <?= $block->name ?>
                                    <small><?= $block->latest_version->version ?></small>
                                </div>
                                <div class="description"><?= $block->description ?></div>
                                <div class="controls">
                                    <form action="?page=toybox-block-library&area=browse" method="post">
                                        <?php
                                        $formNonce = wp_nonce_field('toybox_block_import', 'toybox_block_import_nonce');
                                        $export    = get_submit_button('Import');
                                        ?>
                                        <?= $formNonce ?>
                                        <input type="hidden" name="block" value="<?= $block->id ?>">
                                        <input type="hidden" name="slug" value="<?= $block->slug_name ?>">
                                        <?= $export ?>
                                    </form>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; ?>
                </div>
            <?php endif; ?>
        <?php elseif ($area === "export") : ?>
            <?php if (! empty($_POST)) : ?>
                <?php
                // Export the block (zip it and volley it at the API)
                $name        = $_POST["name"];
                $description = $_POST["description"];
                $blockDir    = $_POST["block"];
                $version     = $_POST["version"];
                $path        = explode("/", $_POST["block"]);
                $blockName   = end($path);

                $api = new API();

                ?>
                <?php if ($api->versionExists($name, $version)) : ?>
                    <div class="alert alert-error">
                        This version already exists. Please update the block's version constraint to export to the Block Library.
                    </div>
                <?php else : ?>
                    <?php

                    if (! file_exists(WP_CONTENT_DIR . "/blocks")) {
                        mkdir(WP_CONTENT_DIR . "/blocks");
                    }

                    if (! file_exists(WP_CONTENT_DIR . "/blocks/{$blockName}")) {
                        mkdir(WP_CONTENT_DIR . "/blocks/{$blockName}");
                    }

                    $fileName = WP_CONTENT_DIR . "/blocks/{$blockName}/{$version}.zip";

                    $zip = new \PhpZip\ZipFile();

                    try {
                        $zip->addDirRecursive($blockDir)
                            ->saveAsFile($fileName)
                            ->close();
                    } catch(\PhpZip\Exception\ZipException $e) {
                        // handle exception
                    } finally {
                        $zip->close();
                    }

                    // Volley the zip at the API
                    $export = $api->exportBlock($name, $description, $version, $fileName);

                    ?>
                    <?php if ($export === true) : ?>
                        <div class="alert alert-success">
                            Exported the block to the API successfully!
                        </div>
                    <?php else: ?>
                        <div class="alert alert-error">
                            Failed to export the block to the API.
                        </div>
                    <?php endif; ?>
                <?php endif; ?>
            <?php else : ?>
                <div class="toybox-blocks-grid">
                    <?php foreach (glob(get_theme_file_path("blocks/*")) as $blockDir) : ?>
                        <?php
                        $blockJson = json_decode(file_get_contents("{$blockDir}/block.json"));
                        ?>
                        <div class="toybox-block">
                            <div class="toybox-block-preview">
                                <?php
                                $blockSlug = explode("/", $blockJson->name)[1];
                                ?>
                                <img src="<?= get_theme_file_uri("blocks/{$blockSlug}/preview.png") ?>" alt="<?= $blockJson->title ?> Preview">
                            </div>

                            <div class="toybox-block-meta">
                                <div class="title">
                                    <?= $blockJson->title ?>
                                    <small><?= $blockJson->version ?></small>
                                </div>
                                <div class="description"><?= $blockJson->description ?></div>
                                <div class="controls">
                                    <form action="?page=toybox-block-library&area=export" method="post">
                                        <?php
                                        $formNonce = wp_nonce_field('toybox_block_export', 'toybox_block_export_nonce');
                                        $export    = get_submit_button('Export');
                                        ?>
                                        <?= $formNonce ?>
                                        <input type="hidden" name="name" value="<?= $blockJson->title ?>">
                                        <input type="hidden" name="description" value="<?= $blockJson->description ?>">
                                        <input type="hidden" name="version" value="<?= $blockJson->version ?>">
                                        <input type="hidden" name="block" value="<?= $blockDir ?>">
                                        <?= $export ?>
                                    </form>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; ?>
                </div>
            <?php endif; ?>
        <?php endif; ?>
    </div>
</div>

<style>
    .toybox-wrapper .block-library-filters {
        margin-top: 1rem;
    }

    .toybox-wrapper .toybox-blocks-grid {
        padding-top: 1rem;
        padding-bottom: 1rem;
        display: grid;
        grid-template-columns: repeat(4, minmax(0, 1fr));
        gap: 1rem;
    }

    .toybox-wrapper .toybox-block {
        display: grid;
        gap: 1rem;
        grid-template-columns: minmax(0, 1fr) minmax(0, 2fr);
        border: 1px solid #c3c4c7;
        background: white;
        padding: 1rem;
    }

    .toybox-wrapper .toybox-block .toybox-block-preview img {
        max-width: 100%;
        height: auto;
        aspect-ratio: 300/180;
        object-fit: cover;
        object-position: center center;
    }

    .toybox-wrapper .toybox-block .toybox-block-meta .title {
        font-size: 1.2rem;
        font-weight: 500;
        margin: 0 0 1rem;
    }

    .toybox-wrapper .toybox-block .toybox-block-meta .description {
        margin: 0 0 1rem;
    }

    .toybox-wrapper .alert {
        padding: 1rem;
        border-radius: .25rem;
        margin-top: 1rem;
    }

    .toybox-wrapper .alert.alert-success {
        background: #44bd32;
        color: #f5f6fa;
    }

    .toybox-wrapper .alert.alert-error {
        background: #e84118;
        color: #f5f6fa;
    }
</style>
