<?php

use YahnisElsts\PluginUpdateChecker\v5\PucFactory;

class Core
{
    const TEXT_DOMAIN = "toybox_plugin";

    public API $api;

    public string $version = "1.1.1";

    public function __construct()
    {
        require_once(__DIR__ . "/API.php");

        $this->api = new API();
    }

    public function boot($file): void
    {
        add_action("admin_menu", function () {
            add_management_page(
                __("Toybox", static::TEXT_DOMAIN),
                __("Toybox", static::TEXT_DOMAIN),
                "read",
                "toybox",
                [$this, "addToyboxPage"]
            );

            if ($this->api->isConnected()) {
                $site = $this->api->getSite();

                if ($site && $site->is_toybox === true) {
                    add_menu_page(
                        __("Block Library", static::TEXT_DOMAIN),
                        __("Block Library", static::TEXT_DOMAIN),
                        "manage_options",
                        "toybox-block-library",
                        function () {
                            include __DIR__ . '/block-library.php';
                        },
                        "",
                        68
                    );
                }
            }
        });

        add_action("admin_enqueue_scripts", function ($hook) {
            // wp_die($hook);

            if ($hook === "tools_page_toybox-maintainer") {
                add_thickbox();
            }
        });

        // Add check-in schedule
        add_action("wp", function () {
            if (! wp_next_scheduled("toybox_checkin_hook")) {
                wp_schedule_event(time(), "hourly", "toybox_checkin_hook");
            }
        });

        add_action("toybox_checkin_hook", function () {
            $this->api->checkIn();
        });

        // Add update checker
        add_action("plugins_loaded", function () use ($file) {
            PucFactory::buildUpdateChecker(
                'https://toybox.maxweb.cloud/api/v2/plugin/toybox/json',
                $file, //Full path to the main plugin file or functions.php.
                'toybox'
            );
        });
    }

    public function addToyboxPage(): void
    {
        // Work out what area we're in
        $area = $_GET["area"] ?? "";

        echo "<div class='wrap toybox-wrapper'>";
        echo "<h1>Toybox</h1>";

        echo "
            <nav class=\"nav-tab-wrapper\">
                <a href=\"?page=toybox&area=api\" class=\"nav-tab " . (($area === "" || $area === "api") ? "nav-tab-active" : "") . "\">API</a>
                <a href=\"?page=toybox&area=updates\" class=\"nav-tab " . (($area === "updates") ? "nav-tab-active" : "") . "\">Updates</a>
                <a href=\"?page=toybox&area=environments\" class=\"nav-tab " . (($area === "environments") ? "nav-tab-active" : "") . "\">Environments</a>
            </nav>
        ";

        echo "<div class=\"tab-content\">";

        $this->showMaintenancePage($area);

        echo "</div>";
        echo "</div>";
    }

    public function showMaintenancePage(string $area): void
    {
        require_once(__DIR__ . "/Maintainer.php");

        $maintainer = new Maintainer();

        switch ($area) {
            case "":
            case "api":
                $maintainer->showApiPage();
                break;

            case "updates":
                $maintainer->showUpdatesPage();
                break;

            case "backups":
                $maintainer->showBackupsPage();
                break;

            case "environments":
                $maintainer->showEnvironmentsPage();
                break;
        }
    }
}
