<?php

global $backpack;

$documentRoot      = $_SERVER["DOCUMENT_ROOT"];
$defaultBackupPath = realpath($documentRoot . DIRECTORY_SEPARATOR . ".." . DIRECTORY_SEPARATOR) . DIRECTORY_SEPARATOR . "backups";

if (isset($_POST['mws_backpack_settings_nonce']) && wp_verify_nonce($_POST['mws_backpack_settings_nonce'], 'mws_backpack_settings_action')) {
    // Nonce is valid, process the form
    update_option('mws_backpack_mysqldump_path',        $_POST['mws_backpack_mysqldump_path']);
    update_option('mws_backpack_backup_path',           $_POST['mws_backpack_backup_path']);
    update_option('mws_backpack_aws_access_key_id',     $backpack->encrypt($_POST['mws_backpack_aws_access_key_id']));
    update_option('mws_backpack_aws_secret_access_key', $backpack->encrypt($_POST['mws_backpack_aws_secret_access_key']));
    update_option('mws_backpack_aws_bucket_name',       $_POST['mws_backpack_aws_bucket_name']);
    update_option('mws_backpack_aws_bucket_region',     $_POST['mws_backpack_aws_bucket_region']);
    update_option('mws_backpack_aws_backup_prefix',     $_POST['mws_backpack_aws_backup_prefix']);

    echo '<div class="notice notice-success is-dismissible"><p>' . esc_html__('Settings saved successfully.', 'mws-backpack') . '</p></div>';
} elseif (isset($_POST['mws_backpack_settings_nonce']) && ! wp_verify_nonce($_POST['mws_backpack_settings_nonce'], 'mws_backpack_settings_action')) {
    // Invalid nonce, handle the error
    echo '<div class="notice notice-error is-dismissible"><p>' . esc_html__('Invalid nonce. Please try again.', 'mws-backpack') . '</p></div>';
}

?>

<form action="" method="post">
    <?php wp_nonce_field('mws_backpack_settings_action', 'mws_backpack_settings_nonce'); ?>

    <h2>Settings</h2>

    <table class="form-table">
        <tr>
            <th scope="row">
                <label for="mws_backpack_mysqldump_path">
                    <?php esc_html_e('mysqldump Path', 'mws-backpack') ?>
                </label>
            </th>

            <td>
                <input type="text" name="mws_backpack_mysqldump_path" id="mws_backpack_mysqldump_path" value="<?= esc_attr(get_option('mws_backpack_mysqldump_path', $defaultBackupPath)) ?>" class="regular-text">
                <p class="description" id="tagline-mws_backpack_mysqldump_path">
                    This is the full path to the <code>mysqldump</code> binary.
                </p>
            </td>
        </tr>

        <tr>
            <th scope="row">
                <label for="mws_backpack_backup_path">
                    <?php esc_html_e('Backup Path', 'mws-backpack') ?>
                </label>
            </th>

            <td>
                <input type="text" name="mws_backpack_backup_path" id="mws_backpack_backup_path" value="<?= esc_attr(get_option('mws_backpack_backup_path', $defaultBackupPath)) ?>" class="regular-text">
                <p class="description" id="tagline-mws_backpack_backup_path">
                    This is the path to the directory where backups will be stored before they are uploaded off-site. It
                    should be writable by the web server, and preferably stored outside the public directory.
                </p>
            </td>
        </tr>
    </table>

    <h2>Credentials</h2>

    <table class="form-table">
        <tr>
            <th scope="row">
                <label for="mws_backpack_aws_access_key_id">
                    <?php esc_html_e('AWS Access Key ID', 'mws-backpack') ?>
                </label>
            </th>

            <td>
                <input type="text" name="mws_backpack_aws_access_key_id" id="mws_backpack_aws_access_key_id" value="<?= esc_attr($backpack->decrypt(get_option('mws_backpack_aws_access_key_id'))) ?>" class="regular-text">
            </td>
        </tr>

        <tr>
            <th scope="row">
                <label for="mws_backpack_aws_secret_access_key">
                    <?php esc_html_e('AWS Secret Access Key', 'mws-backpack') ?>
                </label>
            </th>

            <td>
                <input type="<?= ((! empty(get_option('mws_backpack_aws_secret_access_key'))) ? "password" : "text") ?>" name="mws_backpack_aws_secret_access_key" id="mws_backpack_aws_secret_access_key" value="<?= esc_attr($backpack->decrypt(get_option('mws_backpack_aws_secret_access_key'))) ?>" class="regular-text">
            </td>
        </tr>

        <tr>
            <th scope="row">
                <label for="mws_backpack_aws_bucket_name">
                    <?php esc_html_e('Bucket Name', 'mws-backpack') ?>
                </label>
            </th>

            <td>
                <input type="text" name="mws_backpack_aws_bucket_name" id="mws_backpack_aws_bucket_name" value="<?= esc_attr(get_option('mws_backpack_aws_bucket_name')) ?>" class="regular-text">
            </td>
        </tr>

        <tr>
            <th scope="row">
                <label for="mws_backpack_aws_bucket_region">
                    <?php esc_html_e('Bucket Region', 'mws-backpack') ?>
                </label>
            </th>

            <td>
                <input type="text" name="mws_backpack_aws_bucket_region" id="mws_backpack_aws_bucket_region" value="<?= esc_attr(get_option('mws_backpack_aws_bucket_region')) ?>" class="regular-text">
            </td>
        </tr>

        <tr>
            <th scope="row">
                <label for="mws_backpack_aws_backup_prefix">
                    <?php esc_html_e('Backup Path Prefix', 'mws-backpack') ?>
                </label>
            </th>

            <td>
                <input type="text" name="mws_backpack_aws_backup_prefix" id="mws_backpack_aws_backup_prefix" value="<?= esc_attr(get_option('mws_backpack_aws_backup_prefix')) ?>" class="regular-text">
                <p class="description" id="tagline-mws_backpack_aws_backup_prefix">
                    This is prefixed to the backup path when a backup is uploaded to S3.
                </p>
            </td>
        </tr>
    </table>

    <p class="submit">
        <input type="submit" name="submit_settings" id="submit" class="button button-primary" value="<?php esc_attr_e('Save Changes', 'mws-backpack'); ?>">
    </p>
</form>