<?php

if (! defined('WP_ADMIN') || ! WP_ADMIN) {
    die('This script can only be run in the WordPress admin area.');
}

$path = (! empty($_GET['path'])) ? rawurldecode($_GET['path']) : ABSPATH;

$basePath = realpath($path);

// Check path existence
if (file_exists($basePath) === false) {
    return ["success" => false];
}

// Make sure it is a directory
if (is_dir($basePath) === false) {
    return ["success" => false];
}

$files = scandir($basePath);


usort($files, function ($a, $b) use ($basePath) {
    $aIsDir = is_dir($basePath . DIRECTORY_SEPARATOR . $a);
    $bIsDir = is_dir($basePath . DIRECTORY_SEPARATOR . $b);

    if ($aIsDir === $bIsDir) {
        return strcasecmp($a, $b); // Sort alphabetically if both are the same type
    }

    return $aIsDir ? -1 : 1; // Directories first
});

?>

<table class="widefat fixed striped" id="path-browser">
    <thead>
        <tr>
            <th style="width: 1rem;"></th>
            <th>File Name</th>
            <th>Size</th>
        </tr>
    </thead>
    <tbody>
        <?php foreach ($files as $file) : ?>
            <?php if ($file === '..') continue; ?>
            <tr>
                <td>
                    <?php if ($file !== '..') : ?>
                        <?php
                        $newPath = realpath($basePath . DIRECTORY_SEPARATOR . $file);
                        ?>
                        <input type="checkbox" class="path-selector" data-path="<?= $newPath ?>">
                    <?php endif; ?>
                </td>

                <td>
                    <?php if (is_dir($basePath . DIRECTORY_SEPARATOR . $file)) : ?>
                        <?php
                        $newPath = realpath($basePath . DIRECTORY_SEPARATOR . $file);
                        if ($file === '.') $file = "This Directory";
                        ?>
                        <a href="#" onclick="browsePath('<?= rawurlencode($newPath) ?>'); return false;">
                            <?= $file ?>
                        </a>
                    <?php else : ?>
                        <?= $file ?>
                    <?php endif; ?>
                </td>

                <td>
                    <?php if (is_file($basePath . DIRECTORY_SEPARATOR . $file)) : ?>
                        <?php
                        $size = filesize($basePath . DIRECTORY_SEPARATOR . $file);
                        if ($size >= 1073741824) { // 1 GB = 1024^3 bytes
                            echo round($size / 1073741824, 2) . ' GB';
                        } elseif ($size >= 1048576) { // 1 MB = 1024^2 bytes
                            echo round($size / 1048576, 2) . ' MB';
                        } elseif ($size >= 1024) { // 1 KB = 1024 bytes
                            echo round($size / 1024, 2) . ' KB';
                        } else {
                            echo $size . ' B';
                        }
                        ?>
                    <?php endif; ?>
                </td>
            </tr>
        <?php endforeach; ?>
    </tbody>
</table>