<?php

/*
Plugin Name: BackPack by Maxweb
Plugin URI: https://maxwebsolutions.co.uk/
Description: Back up your WordPress website in style.
Version: 1.2.3
Author: Maxweb Solutions
Author URI: https://maxwebsolutions.co.uk
License: GPL2
License URI: http://www.gnu.org/licenses/gpl-2.0.html
Text Domain: mws-backpack
*/

require_once plugin_dir_path(__FILE__) . 'vendor/autoload.php';
require_once plugin_dir_path(__FILE__) . 'includes/class_backpack_compress.php';
require_once plugin_dir_path(__FILE__) . 'includes/class_backpack_database.php';
require_once plugin_dir_path(__FILE__) . 'includes/class_backpack_export.php';
require_once plugin_dir_path(__FILE__) . 'includes/class_backpack_files.php';
require_once plugin_dir_path(__FILE__) . 'includes/class_backpack.php';

$backpack = new Backpack(__FILE__);

// Register plugin installation hooks
register_activation_hook(__FILE__, [$backpack, "install"]);

// Register upgrade hook
add_action("plugins_loaded", [$backpack, "upgrade"]);

$backpack->equip();
