<h2>History</h2>

<?php

use Carbon\Carbon;

global $backpack;

// Fetch history
$history = $backpack->getBackupHistory();

?>

<div>
    <table class="widefat fixed striped" id="plugin-update-table" style="margin-bottom: 1rem;">
        <thead>
            <tr>
                <th>Schedule</th>
                <th>Download</th>
                <th>Created At</th>
            </tr>
        </thead>
        <tbody>
            <?php if (empty($history)) : ?>
                <tr>
                    <td colspan="3">No backup history could be found.</td>
                </tr>
            <?php else : ?>
                <?php foreach ($history as $item) : ?>
                    <tr>
                        <td><?= $item["name"] ?></td>
                        <td>
                            <a href="<?= (new Backpack_Export($backpack))->fromS3($item["path"]) ?>" class="button button-primary">
                                Download
                            </a>
                        </td>
                        <td>
                            <?php
                            $createdAt = Carbon::createFromFormat("Y-m-d H:i:s", $item["created_at"], $backpack->getTimezone());
                            ?>
                            <?= $createdAt->format("d/m/Y H:i") ?>
                            (<?= $createdAt->diffForHumans() ?>)
                        </td>
                    </tr>
                <?php endforeach; ?>
            <?php endif; ?>
        </tbody>
    </table>
</div>